<?php
/**
 * @package     mod_jttabs
 * @copyright   Copyright (C) 2007 - 2023 http://www.joomlatema.net, Inc. All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 * @author     	JoomlaTema.Net
 * @link 		http://www.joomlatema.net
 **/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldArticles extends JFormField
{
    protected $type = 'Articles'; //the form field type
    
    protected function getInput()
    {
    // Initialize variables.
        $html = array();
        $attr = '';
        
        $options = array();
        $db	= JFactory::getDbo();
        
        $db->setQuery(
          'SELECT `id` as value, `title` as text FROM #__content;'
        );
        
        try
        {
          $articles = $db->loadObjectList();
        }
        catch (RuntimeException $e)
        {
  
		  JFactory::getApplication()->enqueueMessage();
        }
        
        if (empty($articles)) $articles = array();
        
        $attr .= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';
        
        $attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
        $attr .= $this->multiple ? ' multiple="multiple"' : '';
        
        // Create a regular list.
        $html[] = JHtml::_('select.genericlist', $articles, $this->name, $attr, 'value', 'text', $this->value, $this->id);
        return implode("\n", $html);
    }
}
