<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/calvarybaptist/public_html/templates/rt_phoenix/particles/slider.yaml',
    'modified' => 1737418573,
    'data' => [
        'name' => 'Slider',
        'description' => 'Background slideshow with small picture',
        'type' => 'particle',
        'icon' => 'fa-youtube-play',
        'form' => [
            'overrideable' => false,
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable particle.',
                    'default' => true
                ],
                '_tabs' => [
                    'type' => 'container.tabs',
                    'fields' => [
                        '_tab_settings' => [
                            'label' => 'Settings',
                            'overridable' => false,
                            'fields' => [
                                'source' => [
                                    'type' => 'select.select',
                                    'label' => 'Content Source',
                                    'description' => 'Choose if the content should be loaded from the platform or particle itself.',
                                    'default' => 'particle',
                                    'options' => [
                                        'particle' => 'Particle',
                                        'joomla' => 'Joomla'
                                    ]
                                ],
                                'height' => [
                                    'type' => 'input.text',
                                    'label' => 'Slide Height',
                                    'description' => 'Set minimal image height',
                                    'placeholder' => '60vh',
                                    'default' => '60vh',
                                    'pattern' => '\\d+(\\.\\d+){0,1}(rem|em|ex|ch|vw|vh|vmin|vmax|%|px|cm|mm|in|pt|pc)'
                                ],
                                'heightMobile' => [
                                    'type' => 'input.text',
                                    'label' => 'Slide Height (Mobile)',
                                    'description' => 'Set minimal image height in mobile',
                                    'placeholder' => '500px',
                                    'default' => '500px',
                                    'pattern' => '\\d+(\\.\\d+){0,1}(rem|em|ex|ch|vw|vh|vmin|vmax|%|px|cm|mm|in|pt|pc)'
                                ],
                                'nav' => [
                                    'type' => 'select.select',
                                    'label' => 'Prev / Next',
                                    'description' => 'Enable or disable the Prev / Next navigation. Arrows will not appear unless they are actually required (i.e. more items than currently visible).',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'autoplay' => [
                                    'type' => 'select.select',
                                    'label' => 'Autoplay',
                                    'description' => 'Decide if you want your slideshow to autoplay or not.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'autoplayTimeout' => [
                                    'type' => 'input.number',
                                    'label' => 'Autoplay Timeout',
                                    'description' => 'The time between each auto transition',
                                    'default' => 8000
                                ],
                                'loop' => [
                                    'type' => 'select.select',
                                    'label' => 'Loop',
                                    'description' => 'Decide if you want your slideshow to loop or not.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'speed' => [
                                    'type' => 'input.number',
                                    'label' => 'Speed',
                                    'description' => 'Transition speed',
                                    'default' => 800
                                ],
                                'pattern' => [
                                    'type' => 'select.select',
                                    'label' => 'Pattern',
                                    'description' => 'Enable or disable pattern.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'centered' => [
                                    'type' => 'select.select',
                                    'label' => 'Centered',
                                    'description' => 'Enable or disable centered slide.',
                                    'default' => 'enabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ],
                                'touchmove' => [
                                    'type' => 'select.select',
                                    'label' => 'Touch Move',
                                    'description' => 'Decide if you want to be able to move slides using touch.',
                                    'default' => 'disabled',
                                    'options' => [
                                        'enabled' => 'Enable',
                                        'disabled' => 'Disable'
                                    ]
                                ]
                            ]
                        ],
                        '_tab_collection' => [
                            'label' => 'Particle Items',
                            'overridable' => false,
                            'fields' => [
                                'items' => [
                                    'type' => 'collection.list',
                                    'array' => true,
                                    'label' => 'Items',
                                    'description' => 'Create slider items.',
                                    'value' => 'title',
                                    'ajax' => true,
                                    'fields' => [
                                        '.title' => [
                                            'type' => 'input.text',
                                            'label' => 'Title',
                                            'description' => 'Enter slide title'
                                        ],
                                        '.description' => [
                                            'type' => 'textarea.textarea',
                                            'label' => 'Additional Description'
                                        ],
                                        '.image' => [
                                            'type' => 'input.imagepicker',
                                            'label' => 'Image',
                                            'description' => 'Select image for slideshow',
                                            'placeholder' => 'Pick an image'
                                        ],
                                        '.link' => [
                                            'type' => 'input.text',
                                            'label' => 'Link',
                                            'description' => 'Set a URL for the item to take visitors to (YouTube requires /embed/ url).'
                                        ],
                                        '.linktarget' => [
                                            'type' => 'select.selectize',
                                            'label' => 'Link Target',
                                            'description' => 'Set the target for the URL to open in.',
                                            'placeholder' => 'Select...',
                                            'default' => 'modal',
                                            'options' => [
                                                '_self' => 'Self',
                                                '_blank' => 'New Window',
                                                'modal' => 'Modal'
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ],
                        '_tab_slides' => [
                            'label' => 'Slides',
                            'overridable' => false,
                            'fields' => [
                                'largedesktopinfo' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Large Desktop'
                                ],
                                'largedesktopslides' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per View',
                                    'description' => 'Number of slides per view',
                                    'default' => 4,
                                    'min' => 1
                                ],
                                'largedesktopgroup' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per Group',
                                    'description' => 'Number of slides per transition',
                                    'default' => 1,
                                    'min' => 1
                                ],
                                'largedesktopspace' => [
                                    'type' => 'input.number',
                                    'label' => 'Space Between',
                                    'description' => 'Amount of space between each thumb (px)',
                                    'default' => 35,
                                    'min' => 0
                                ],
                                'desktopinfo' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Desktop'
                                ],
                                'desktopslides' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per View',
                                    'description' => 'Number of slides per view',
                                    'default' => 4,
                                    'min' => 1
                                ],
                                'desktopgroup' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per Group',
                                    'description' => 'Number of slides per transition',
                                    'default' => 1,
                                    'min' => 1
                                ],
                                'desktopspace' => [
                                    'type' => 'input.number',
                                    'label' => 'Space Between',
                                    'description' => 'Amount of space between each thumb (px)',
                                    'default' => 35,
                                    'min' => 0
                                ],
                                'tabletinfo' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Tablet'
                                ],
                                'tabletslides' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per View',
                                    'description' => 'Number of slides per view',
                                    'default' => 3,
                                    'min' => 1
                                ],
                                'tabletgroup' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per Group',
                                    'description' => 'Number of slides per transition',
                                    'default' => 1,
                                    'min' => 1
                                ],
                                'tabletspace' => [
                                    'type' => 'input.number',
                                    'label' => 'Space Between',
                                    'description' => 'Amount of space between each thumb (px)',
                                    'default' => 35,
                                    'min' => 0
                                ],
                                'mobileinfo' => [
                                    'type' => 'separator.note',
                                    'class' => 'alert alert-info',
                                    'content' => 'Mobile'
                                ],
                                'mobileslides' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per View',
                                    'description' => 'Number of slides per view',
                                    'default' => 2,
                                    'min' => 1
                                ],
                                'mobilegroup' => [
                                    'type' => 'input.number',
                                    'label' => 'Slides Per Group',
                                    'description' => 'Number of slides per transition',
                                    'default' => 1,
                                    'min' => 1
                                ],
                                'mobilespace' => [
                                    'type' => 'input.number',
                                    'label' => 'Space Between',
                                    'description' => 'Amount of space between each thumb (px)',
                                    'default' => 35,
                                    'min' => 0
                                ]
                            ]
                        ],
                        '_tab_articles' => [
                            'label' => 'Articles',
                            'overridable' => false,
                            'fields' => [
                                'article.filter.categories' => [
                                    'type' => 'joomla.categories',
                                    'label' => 'Categories',
                                    'description' => 'Select the categories the articles should be taken from.',
                                    'overridable' => false
                                ],
                                'article.filter.articles' => [
                                    'type' => 'input.text',
                                    'label' => 'Articles',
                                    'description' => 'Enter the Joomla articles that should be shown. It should be a list of article IDs separated with a comma (i.e. 1,2,3,4,5).',
                                    'overridable' => false
                                ],
                                'article.filter.featured' => [
                                    'type' => 'select.select',
                                    'label' => 'Featured Articles',
                                    'description' => 'Select how Featured articles should be filtered.',
                                    'default' => '',
                                    'options' => [
                                        'include' => 'Include Featured',
                                        'exclude' => 'Exclude Featured',
                                        'only' => 'Only Featured'
                                    ],
                                    'overridable' => false
                                ],
                                'article.limit.total' => [
                                    'type' => 'input.text',
                                    'label' => 'Number of Articles',
                                    'description' => 'Enter the maximum number of articles to display.',
                                    'default' => 5,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.limit.start' => [
                                    'type' => 'input.text',
                                    'label' => 'Start From',
                                    'description' => 'Enter offset specifying the first article to return. The default is \'0\' (the first article).',
                                    'default' => 0,
                                    'pattern' => '\\d{1,2}',
                                    'overridable' => false
                                ],
                                'article.sort.orderby' => [
                                    'type' => 'select.select',
                                    'label' => 'Order By',
                                    'description' => 'Select how the articles should be ordered by.',
                                    'default' => 'publish_up',
                                    'options' => [
                                        'publish_up' => 'Published Date',
                                        'created' => 'Created Date',
                                        'modified' => 'Last Modified Date',
                                        'title' => 'Title',
                                        'ordering' => 'Ordering',
                                        'hits' => 'Hits',
                                        'id' => 'ID',
                                        'alias' => 'Alias'
                                    ],
                                    'overridable' => false
                                ],
                                'article.sort.ordering' => [
                                    'type' => 'select.select',
                                    'label' => 'Ordering Direction',
                                    'description' => 'Select the direction the articles should be ordered by.',
                                    'default' => 'ASC',
                                    'options' => [
                                        'ASC' => 'Ascending',
                                        'DESC' => 'Descending'
                                    ],
                                    'overridable' => false
                                ]
                            ]
                        ],
                        '_tab_display' => [
                            'label' => 'Articles Display',
                            'overridable' => false,
                            'fields' => [
                                'article.display.image.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Image',
                                    'description' => 'Select if and what image of the article should be shown.',
                                    'options' => [
                                        'intro' => 'Intro',
                                        'full' => 'Full',
                                        '' => 'None'
                                    ]
                                ],
                                'article.display.text.type' => [
                                    'overridable' => false,
                                    'type' => 'select.select',
                                    'label' => 'Article Text',
                                    'description' => 'Select if and how the article text should be shown.',
                                    'options' => [
                                        'intro' => 'Introduction',
                                        'full' => 'Full Article',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.text.limit' => [
                                    'overridable' => false,
                                    'type' => 'input.text',
                                    'label' => 'Text Limit',
                                    'description' => 'Type in the number of characters the article text should be limited to.',
                                    'pattern' => '\\d+'
                                ],
                                'article.display.text.formatting' => [
                                    'overridable' => false,
                                    'type' => 'select.select',
                                    'label' => 'Text Formatting',
                                    'description' => 'Select the formatting you want to use to display the article text.',
                                    'options' => [
                                        'text' => 'Plain Text',
                                        'html' => 'HTML'
                                    ]
                                ],
                                'article.display.title.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Title',
                                    'description' => 'Select if the article title should be shown.',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.title.limit' => [
                                    'type' => 'input.text',
                                    'label' => 'Title Limit',
                                    'description' => 'Enter the maximum number of characters the article title should be limited to.',
                                    'pattern' => '\\d+(\\.\\d+){0,1}'
                                ],
                                'article.display.link.enabled' => [
                                    'type' => 'select.select',
                                    'label' => 'Link',
                                    'description' => 'Select if the item should link to the page.',
                                    'options' => [
                                        'show' => 'Show',
                                        '' => 'Hide'
                                    ]
                                ],
                                'article.display.link.target' => [
                                    'type' => 'select.selectize',
                                    'label' => 'Title Target',
                                    'description' => 'Target browser window when the title is clicked.',
                                    'placeholder' => 'Select...',
                                    'default' => '_self',
                                    'options' => [
                                        '_self' => 'Self',
                                        '_blank' => 'New Window'
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ]
    ]
];
